import type { FormatConfig } from "./connection";
import type { AudioWorkletConfig } from "../BaseConversation";
export type OutputConfig = {
    outputDeviceId?: string;
};
export declare class Output {
    readonly context: AudioContext;
    readonly analyser: AnalyserNode;
    readonly gain: GainNode;
    readonly worklet: AudioWorkletNode;
    readonly audioElement: HTMLAudioElement;
    static create({ sampleRate, format, outputDeviceId, workletPaths, }: FormatConfig & OutputConfig & AudioWorkletConfig): Promise<Output>;
    private constructor();
    setOutputDevice(deviceId?: string): Promise<void>;
    close(): Promise<void>;
}
